<?php 

	$show_title = (get_post_meta( get_the_ID(), 'show_title', true )); 
	$show_content = (get_post_meta( get_the_ID(), 'show_content', true )); 
	$show_counters = (get_post_meta( get_the_ID(), 'show_counters', true )); 
	$show_share = (get_post_meta( get_the_ID(), 'show_share', true )); 
	$spotlight = (get_post_meta( get_the_ID(), 'spotlight', true )); 
	$spotlight_content_color = (get_post_meta( get_the_ID(), 'spotlight_content_color', true )); 
	$show_related = (get_post_meta( get_the_ID(), 'show_related', true ));

?>
<?php if ( $spotlight && (is_home() || is_category())): ?>
	<?php if ( has_post_thumbnail() ) { ?>
		<a class="bg-img" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
			<?php the_post_thumbnail(); ?>
		</a>
	<?php }else{ ?>
		<a class="bg-img" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"></a>
	<?php } ?>
	<article class="spotlight <?php echo esc_attr($spotlight_content_color); ?>">
<?php else: ?>
	<article>
	<?php if ( has_post_thumbnail() ) { ?>
		<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
			<?php the_post_thumbnail(); ?>
		</a>
	<?php }else{ ?>
		<?php get_template_part( 'includes/templates/post/post','type'); ?>
	<?php }
endif ?>
	<?php if ($show_title == 'always'): ?>
		<header>
			<div class="post-categories">
				<?php $post_categories = wp_get_post_categories( get_the_ID() );	
					foreach($post_categories as $c){
						$cat = get_category( $c );
						$id = get_cat_ID($cat->name); ?>
						<a href="<?php echo get_category_link( $id ); ?>"><?php echo esc_attr($cat->name); ?></a>
				<?php } ?>
			</div>
			<a href="<?php the_permalink(); ?>">
				<h3><?php the_title(); ?></h3>
			</a>
			<a class='post-date' href="<?php echo get_day_link(get_post_time('Y'), get_post_time('m'), get_post_time('j')); ?>"><?php the_time(get_option( 'date_format' )); ?></a>
		</header>
	<?php endif ?>
	<?php if ($show_content == 'always'): ?>
		<?php the_excerpt(); ?>
	<?php endif ?>
	<?php if ($show_title == 'always' || $show_content == 'always' || $show_counters == 'always' || $show_share == 'always'): ?>
		<footer>
		<?php if ($show_content == 'always' || $show_title == 'always'): ?>
			<a href="<?php the_permalink(); ?>" class="btn btn-default btn-hover read-more"><?php _e('Read more', 'pryaniktheme' ); ?></a>
		<?php endif ?>
		<?php if ($show_counters == 'always'): ?>
			<ul class="list-inline post-counters">
				<li>
					<a href="<?php echo get_permalink(); ?>#comments"><i class="fa fa-comment-o"></i><?php comments_number('0','1','%'); ?></a>
				</li><li>
					<?php echo getPostLikeLink( get_the_ID() ); ?>
				</li>
			</ul>
		<?php endif ?>
		<?php if ($show_share == 'always'): ?>
			<div class="share-btn">
				<p><i class="fa fa-share-alt"></i><?php _e('Share','pryaniktheme'); ?></p>
				<ul class="list-inline">
					<li>
						<a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo get_permalink($post->ID); ?>" onclick="window.open(this.href, 'mywin','left=20,top=20,width=500,height=500,toolbar=1,resizable=0'); return false;"><i class="fa fa-facebook"></i></a>
					</li>
					<li>
						<a href="https://twitter.com/home?status=<?php echo get_permalink($post->ID); ?>" onclick="window.open(this.href, 'mywin','left=20,top=20,width=500,height=500,toolbar=1,resizable=0'); return false;"><i class="fa fa-twitter"></i></a>
					</li>
					<li>
						<a href="https://plus.google.com/share?url=<?php echo get_permalink($post->ID); ?>" onclick="window.open(this.href, 'mywin','left=20,top=20,width=500,height=500,toolbar=1,resizable=0'); return false;"><i class="fa fa-google-plus"></i></a>
					</li>
				</ul>
			</div>
		<?php endif ?>
		</footer>
	<?php endif ?>
</article>