/*
 * Flickrush 1.3 - A jQuery flickr plugin
 *
 * Copyright (c) 2010 Philip Beel (http://www.theodin.co.uk/)
 * Dual licensed under the MIT (http://www.opensource.org/licenses/mit-license.php) 
 * and GPL (http://www.opensource.org/licenses/gpl-license.php) licenses.
 *
 * Revision: $Id: jquery.flickrush.js 2013-09-15 $ 
 *
 */
(function ($) {
    $.fn.flickrush = function (options) {
        var defaults = {
            limit: 3,
            col: 'col-md-3 col-sm-3 col-xs-12',
            random: true,
            id: "30005186@N02",
            tags: false
        };
        var options = $.extend(defaults, options),
            flickrurl;
        isSSL = location.protocol === "https:" ? true : false;
        if (isSSL) flickrurl = "https://secure.flickr.com/services/feeds/photos_public.gne?format=json";
        else flickrurl = "http://api.flickr.com/services/feeds/photos_public.gne?format=json"; if (defaults.tags === true) flickrurl += "&tags=" + defaults.tags;
        return this.each(function (options) {
            var act = $(this),
                apiCall = flickrurl,
                container = $("<div class='row'></div>");

            $.getJSON(apiCall + "&id=" + defaults.id + "&jsoncallback=?", function (data) {
                var flickrImage, integer, flickrImages = [],
                    i;
                $.each(data.items, function (i, item) {
                    if (i <= defaults.limit - 1) {
                    	ahref = $("<a></a>").attr({
                            href: item.link,
                            alt: item.tags,
                            class: defaults.col
                        });
                        var div = $("<div></div>").attr({
                            style: 'background-image: url(' + item.media.m + ');'
                        });
                        ahref.append(div);
                        flickrImages.push(ahref)
                    }
                });
                if (defaults.random === true) flickrImages.sort(function () {
                    return 0.5 - Math.random()
                });
                for (var i = 0; i < flickrImages.length; i++){
                    container.append(flickrImages[i]);
                    var width = $(flickrImages[i]).find('div').innerWidth();
                    $(flickrImages[i]).find('div').css('height',width);
                } 
            })
            $(act).append(container);
        })
    }
})(jQuery);